#include <bits/stdc++.h>
#define ll long long
#define MAXN 100010
using namespace std;
ll n,s,a[MAXN];
struct seg_tree
{
    vector<ll> st;
    ll neutral_element=(1<<20)-1;
    void Init()
    {
        s=1;
        while (s<n)
            s <<= 1;
        st.resize(2*s+2,neutral_element);
    }
    void Add(ll pos,ll val,ll x,ll lx,ll rx)
    {
        if (lx>pos || rx<pos)
            return;
        if (lx==rx)
        {
            st[x]=val;
            return;
        }
        ll mid=(lx+rx)/2;
        if (pos<=mid)
            Add(pos,val,2*x,lx,mid);
        else
            Add(pos,val,2*x+1,mid+1,rx);
        st[x]=st[2*x]&st[2*x+1];
    }
    ll Calc(ll l,ll r,ll x,ll lx,ll rx)
    {
        if (lx>r || rx<l)
            return neutral_element;
        if (lx>=l && rx<=r)
            return st[x];
        ll mid=(lx+rx)/2;
        return Calc(l,r,2*x,lx,mid)&Calc(l,r,2*x+1,mid+1,rx);
    }
};
seg_tree S;
int main()
{
    ios::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    cin >> n;
    S.Init();
    ll cnt=0;
    for (ll i=1;i<=n;i++)
    {
        cin >> a[i];
        S.Add(i,a[i],1,1,s);
        cnt+=(a[i]>3);
    }
    ll q,t,x,y;
    cin >> q;
    while (q--)
    {
        cin >> t >> x;
        if (t==1)
        {
            cin >> y;
            cnt-=(a[x]>3);
            S.Add(x,y,1,1,s);
            cnt+=(a[x]>3);
            continue;
        }
        if (!cnt)
        {
            ll l=0,r=n,mid,ans=-1;
            while (l<=r)
            {
                mid=(l+r)/2;
                bool ima=false;
                if (x-mid>0 && S.Calc(x-mid,x,1,1,s)==0)
                    ima=true;
                if (x+mid<=n && S.Calc(x,x+mid,1,1,s)==0)
                    ima=true;
                if (ima)
                {
                    ans=mid;
                    r=mid-1;
                }
                else
                    l=mid+1;
            }
            cout << ans << "\n";
            continue;
        }
        ll ans=LLONG_MAX;
        for (ll i=1;i<=x;i++)
        {
            ll l=x,r=n,mid;
            while (l<=r)
            {
                mid=(l+r)/2;
                if (S.Calc(i,mid,1,1,s))
                    l=mid+1;
                else
                {
                    r=mid-1;
                    ans=min(ans,mid-i+min(x-i,mid-x));
                }
            }
        }
        if (ans==LLONG_MAX)
            cout << -1 << "\n";
        else
            cout << ans << "\n";
    }
    return 0;
}
/**
7
7 2 2 7 5 4 4
1
2 4
**/